#define NumberOf(arg) ((unsigned int) (sizeof (arg) / sizeof (arg [0]))) // calculates the number of layers (in this case 4)
#define _1_OPTIMIZE 0B11011110 // https://github.com/GiorgosXou/NeuralNetworks#define-macro-properties

#include <NeuralNetwork.h>

const unsigned int layers[] = {784, 7, 9, 1};
float *output; // 4th layer's output(s)

// It is 1 for each layer  [Pretrained Biases ]
const PROGMEM float biases[] = {1,1,0.6364130};

// It is 784*7 + 7*9 + 9*1 [Pretrained weights] (81% Accuracy) | Possibly overtrained too lol [...]
const PROGMEM float weights[] = {
-0.3283000,-0.8372000, 0.5797000, 0.6972000, 0.2977000,-0.8654000, 0.2938000,-0.7163000,-0.7994000,-0.1740000,-0.4362000, 0.1403000, 0.2210210, 0.3545390, 0.2327380, 0.2323760,-0.4183000, 0.0336000,-0.7751000,-0.3137000, 0.6584000, 0.0279000, 0.4848000, 0.2499000,-0.5635000, 0.8183000, 0.5152000, 0.1172000, 0.8380000, 0.2269000, 0.7568000,-0.0539000,-0.2601000, 0.5544740, 0.3522420, 0.6155810,-0.7194110, 0.1229230, 0.1791880,-0.4012230, 0.0547670, 0.3429600, 0.3202570,-0.6069970,-0.0822740, 0.5155390, 0.2920200,-0.3376300,-0.7697120, 0.4461330,-0.0376450, 0.7244940,-0.1593000, 0.6582000, 0.1318000, 0.5438000,-0.4220000,-0.5703000, 0.3606000, 0.3799130,-0.5194190,-0.7266390,-0.7335230,-0.4735460,-0.5848130,-0.0620810,-1.2763590,-0.2694120,-0.1946630,-0.6112800,-0.8124160,-0.4769460,-0.3170790,-0.2295700,-0.8209750,-0.3218060,-0.3561550,-0.5772840,-1.0221470,-0.5327480,-0.7643240,-0.3508640,-0.2049000,-0.5504000,-0.6557000,-0.8925000,-0.7945080,-0.0181580,-0.5036640, 0.7386350, 0.0632490,-1.5664630,-0.1773950,-1.8444660,-1.7385930,-1.2537580,-0.9621350,-1.6296210,-0.5633650,-0.4832000,-0.0916040, 0.7659230,-0.6651630,-0.6093650,-0.7296480,-0.1075410,-1.3277190,-0.1853700,-0.9315840, 0.0907740,-0.8122510, 0.3514000, 0.8906000,-0.2185000, 0.1113830, 0.7118820, 0.3326760, 0.8003360,-0.5075410,-0.5027770,-0.3490490,-0.2817010,-0.2612390,-1.6224590,-1.0385670,-0.1758080,-0.2505580,-1.2396520,-0.8428630,-0.3266370, 0.4908580, 0.4928960, 0.7815060, 0.3299250, 0.1899740,-0.7502390, 0.1483550,-0.0089270, 0.2974420,-0.4619750, 0.5845000,-0.3096000,-0.3657240, 0.2696660, 0.5115810, 0.7777360,-1.0203530,-0.2204200,-0.2177570,-0.2488880, 0.0226110,-0.2782890,-0.2363720,-1.1537330,-0.6464780, 0.0809470,-0.3050090, 0.0675800, 0.1254460,-0.0170350,-0.3713590, 0.2479190, 0.4120590,-0.4395410,-0.6146450,-0.5334970, 0.4307730,-0.0890850, 0.3596000,-0.1941000,-0.8392310, 0.1639020,-1.3074720,-0.8585460,-0.1689680, 0.6289150,-0.1042250,-0.2687480,-0.6464040,-0.6481050,-0.7319120,-0.4601800,-1.5914720,-0.7626900,-0.6985680,-0.3259250,-0.7070760,-0.5388740, 0.2122480,-0.3381350, 0.1301500, 1.1131400,-0.1446220, 0.2124750,-0.6110110,-0.3408420,-0.6785010,-0.5442880,-0.2870100,-0.7989490,-0.3351000, 0.7254900,-0.1538790, 0.0118880, 0.8916520,-0.3946200,-0.7773370,-0.2322250, 0.0585190,-0.7087940,-1.0478400,-1.2163260,-0.3743840,-0.5575770,-0.1633200, 0.2294860,-0.2343000,-0.0154910, 0.7593640, 0.5928920,-0.3185990,-0.2605710, 0.9490020, 0.7705150, 0.2011720, 0.0581540,-0.2281910,-0.7652140, 0.3139800,-0.0133150,-0.5868380,-0.7428450,-0.5211430, 0.5551300,-0.0623160,-0.7940530,-0.6229450,-0.6734710,-1.2537110,-0.0462340,-0.7393560, 0.1010530,-0.2970450,-0.1914410,-0.1232150,-0.1160520, 0.0696040,-0.0508200,-0.0106840, 1.7461750, 0.5616900,-0.5973320,-0.1168230,-0.0390650, 1.1302510, 0.6882970, 0.0650320, 0.5350150,-0.6799030,-0.5978400,-0.0130680,-0.6663340,-0.8257270,-0.0958910,-0.2718090,-0.0435700,-2.2829870,-0.3890270, 0.2560860,-0.4497030, 0.2457970, 0.0101540, 0.3440070, 0.2948550,-0.5985780, 0.1698900,-0.6806960, 0.2223340,-0.0882990,-0.3601730,-0.2073590,-0.4125650, 0.4975900,-1.2225070, 0.2281260,-0.9546240, 0.2802750, 0.3958790,-0.4420770, 0.4303310, 0.4105740, 0.0795330, 0.4571560,-1.4942240,-1.9232020, 0.5356440,-0.1212240, 0.6474290,-0.2428920, 0.6389710,-0.0881650,-0.1860810, 0.0175880,-0.5293480,-1.0747450, 0.3666830,-0.2468730, 0.6789060,-0.2109390,-0.8598360,-0.0932290, 0.0923790, 0.3077510,-0.1798240,-0.1913730,-0.6829010,-0.0178190, 0.0172960,-0.5736530,-0.2553680,-0.1178230,-1.3892790,-0.7561630, 0.2082620,-0.1569000,-0.3083470, 0.0612170,-0.6977980,-0.3026080, 0.3362020,-0.2037790,-0.5761200,-1.5048710, 0.4751860, 0.7973320, 0.0139440, 0.2163990, 0.3950290,-1.4324080,-0.7234350,-0.1008460,-1.0041410,-0.5249920, 0.3515420, 0.0664710, 0.1599470, 0.6697740, 0.7235710, 1.0520020, 1.7273650, 0.2697110, 0.1661470,-0.0344120, 0.1254070,-0.2569250, 0.0933360,-0.3150360,-0.3596370,-0.7536520,-1.6690470,-0.0369730, 0.7748730, 1.0391280,-0.0433700,-0.1050000,-0.6019680, 0.0660830,-0.5898050,-1.2910130,-0.1243060, 0.6248080, 0.0014630, 0.7808140, 0.5794490, 0.4570290, 0.8736890,-0.0554950, 0.2252330,-0.3143300, 0.2676920,-0.0189440,-0.1262590,-0.0260010,-0.0774730, 0.2200380, 0.8791720, 0.1011060, 0.2723150,-0.3174410,-0.4461090,-0.3861510, 0.0927830, 0.0699000, 0.2696770, 0.4767090,-1.1828140, 0.3127340, 1.1234450, 0.5202350, 0.7287710, 0.6357170, 0.3503280, 0.7902330, 0.2427700, 0.9040010, 0.7294390, 0.0709770, 0.1891090, 0.5293250, 0.5395370, 0.0862000, 0.0743920, 0.8987030,-0.2164330, 0.9720690,-0.5226650,-0.3119210, 0.7668150, 0.7924670,-0.4650360, 0.6491000,-0.0648190, 0.3304360, 0.2083940, 0.8760770, 0.4007100, 0.3007520,-0.2280480, 0.7517890, 0.3532420,-0.1599080,-0.2067220, 0.5747130, 0.9382750, 0.3087750,-0.0650020,-0.0586280, 0.1332570, 0.7568080, 0.7186780,-0.3489990,-0.0209990,-0.2976860,-0.6729800, 0.0315570, 1.0598390,-0.1122090,-0.3427320,-0.8199000, 0.0333170, 0.3018270,-0.2438530,-0.2917430,-0.1947630, 0.5157830, 0.8161790,-0.0546940,-0.2560440,-0.2117960, 0.5713270, 0.0176510, 0.2553700, 0.8322260, 0.9722360, 0.3400670, 0.2839910,-0.0415830, 0.6155460,-0.0588820,-0.1864000,-0.3367330, 0.5416320, 0.6025390, 1.1376440, 0.4474360,-0.4481380,-0.2476000,-0.1925730, 0.8057270, 0.6880350,-0.8130110,-0.7592010, 0.4863390, 0.2355240,-0.3081800, 0.6602600,-0.1611660, 0.5875320,-0.5741990, 0.6630510, 0.2220580, 0.0507390, 1.0040810, 0.6744810, 1.1737520,-0.9607410, 0.6226220,-0.1732160,-0.0446140,-0.4228950, 0.2512870, 0.1183460, 0.4129850, 0.5203370, 0.2560780,-0.6165520, 0.2065930, 0.4377180, 0.0660130,-0.7063860, 0.1303180,-0.2416280,-0.0917190, 0.1069930,-0.5819640, 0.0826280, 0.9360330, 0.4748950, 0.6591680, 0.5479960,-0.1001920,-0.9536830,-0.7194440,-0.1131950,-0.3211300, 0.3329340,-0.7097760, 1.0959610, 0.0626290,-0.1783730,-0.4433420,-0.5342680,-0.0907100, 0.0939310,-0.8313150, 0.2341520, 0.1089580,-0.6485020,-1.3225310, 0.3167640, 0.0568130, 0.0500850,-0.0111880,-0.4686540,-0.4837670, 0.3473990,-0.4949470,-0.1381170,-0.8041580,-0.3725130,-0.8688920,-0.5397140, 0.2906680,-0.9150750,-0.4378820,-0.5456640,-0.1299780, 0.1751350,-0.3955950, 0.4519160,-0.8917000,-0.8649020, 0.1097460,-0.6707610, 0.0198970,-0.3637770, 0.0507230,-1.3949640,-0.4137120,-0.9363050,-0.3756980, 0.4964350,-0.8530430,-1.3379120,-0.4956400,-1.1916210, 0.0750270,-0.6218510, 0.5541830,-1.3151940,-0.1107610,-0.0849930,-0.7378780, 0.1503530,-1.3547420,-0.7457070,-0.4189300,-0.6552250, 0.5796900, 0.5092490,-0.0051360, 0.5583060,-1.0329260,-0.7510240, 0.1420270, 0.8379970,-0.0526780,-0.4050480, 0.2205560,-0.2529390,-0.3253900, 0.0060800, 0.1631980, 0.5234430,-0.0308400,-0.1356950,-0.5225920, 0.0481630,-0.1566760,-0.1793140, 0.1592220,-0.0354970,-1.0534860,-0.9301740,-0.7219470,-0.4364000,-0.1923340,-0.7309560,-0.2093340,-0.2932790,-0.1938940, 0.4329090,-0.3908280,-0.3448190,-0.0550290,-0.1366140,-0.8086830, 0.0019120,-0.5654350, 0.0845770,-0.8189920, 0.0929650,-0.2529760, 0.4816700, 0.3282850, 0.7586120,-0.3881310, 0.1265360,-0.4502690, 0.0040520,-1.0752330, 0.6087790,-0.0177930,-0.5654000,-0.7506000,-0.5301000, 0.3649410, 1.0559780,-0.6024800,-0.4460380, 0.0523530, 0.5845570,-0.9064950, 0.3769700,-0.3051600,-0.3260630,-0.0866760,-0.7405150, 0.0474440,-0.6873040,-0.0465610,-0.7693220, 0.1335720,-0.0075150,-0.2579870, 0.1852000, 0.2347720,-1.2663020,-0.7988620, 0.1110380,-0.7519130, 0.6587000,-0.8248000,-0.0134000,-0.7093620,-0.0735350,-1.1662080,-1.5042290,-0.5397150,-1.3821770, 0.0046770,-0.1109240,-0.0668120, 0.3033160,-0.2264140, 0.1650910,-0.1903930,-0.4586360, 0.4118700,-0.3385590, 0.6563680, 0.1470580,-0.4819420, 0.0706990,-0.3626190, 0.1189190,-0.4059750,-0.1621320, 0.4099500,-0.0329000,-0.3374000,-0.3756000,-0.3173030, 0.3313800,-0.6922380,-0.7943660,-0.7607300,-0.7052460,-1.5560860,-1.4585040,-0.8736020,-1.1041650,-1.0376090,-0.5294980,-0.6136820,-0.3887380,-0.9942410,-0.5405750,-1.3289860,-1.8386080,-1.4061910,-1.1597370,-0.1655260,-0.8705840, 0.3547700,-0.2494060,-0.7809870,-0.4830000, 0.8733000,-0.5037000, 0.5792000, 0.6446890,-0.2917990,-0.6489870,-0.3115160,-1.3551410,-1.4331740,-1.1264620,-1.8862290,-1.9552310,-1.3011960,-1.7825510,-2.8287370,-1.8934440,-1.2652150,-2.3924820,-1.9829490,-0.8730750,-1.5149540,-0.1718190,-1.0415040, 0.7321530,-0.2353630, 0.1768990, 0.7555000, 0.4046000, 0.2481000,-0.3282000, 0.8029000, 0.7202000, 0.3123150, 0.1105050, 0.1429330, 0.4792050, 0.5955600, 0.2994530,-1.0095430, 0.5461830,-0.2673510,-0.3871210,-1.4483440,-1.0583390,-0.6655530, 0.3131020, 0.0008620,-0.7720570,-0.3290410, 0.0708230,-1.0203220, 0.3162710,-0.6301000, 0.5698000,-0.6503000,-0.8710000,
-0.5904000, 0.7046000,-0.0323000, 0.5324000, 0.1514000,-0.6762000, 0.1718000,-0.5136000, 0.6772000, 0.0894000, 0.2233000, 0.8697000, 0.7045940,-0.0892720,-0.7388990,-0.5115750, 0.4754000,-0.5195000, 0.0608000, 0.1964000, 0.8333000,-0.8365000, 0.4679000, 0.2755000,-0.8674000, 0.5944000,-0.1814000, 0.8824000,-0.3571000,-0.4191000, 0.4503000, 0.6426000,-0.1392000, 0.1176020, 0.2711190,-0.8361440,-0.3792160, 0.0057350,-0.1494220, 0.2362240, 0.7382260, 0.5599230,-0.5544070, 0.3378210,-1.2227500,-0.1470580,-0.5671600, 0.6957880, 0.1300460, 0.5475570, 0.7470130, 0.7893000,-0.3911000, 0.0533000,-0.8044000,-0.6539000,-0.6634000, 0.5922000, 0.4998020, 0.4570330, 0.4057190, 0.1895360, 0.7462900, 0.1880770, 0.6716330, 0.3485070,-0.2705300,-0.5114130, 0.4955750,-0.5821110, 0.7373810, 0.4277040, 0.3480880,-0.4123100, 0.5596850, 0.3774440, 1.3670060,-0.1344030, 0.5224210, 0.0810580, 0.1268790,-0.0855980,-0.1418000, 0.0017000,-0.2656000, 0.5609000, 0.1259720, 0.7104080, 0.1265510, 0.0731680, 0.6992570,-0.0699190, 0.0103560,-0.2502250,-0.0555460,-0.5670040, 0.1678520,-0.3151010,-0.4009610,-0.1280640, 0.1239690, 0.6580700, 1.3310060, 0.4213300, 0.5350150, 1.0611390, 0.5880230, 0.7460630, 0.8904180, 0.6969010,-0.4009570, 0.8860000,-0.4053000,-0.2583000,-0.7054160,-0.5287900,-0.5155920, 0.0350980,-1.0432040, 0.3819700,-0.7470690,-0.8927380,-0.4320780,-0.0829640,-0.7998400,-1.3121980, 0.3894210,-0.9563860, 0.1721510,-0.3631550, 0.0269010, 0.1880080,-0.1357330,-0.0668100, 0.3174500, 1.0059170, 0.2751590, 0.8361600, 0.2590700, 0.3893000, 0.3108000,-0.4702000,-0.7458720, 0.1906190,-0.3429850, 0.8117080,-0.4868980, 0.2565670,-0.3779870,-0.4506210,-0.6799070,-0.2442700,-0.5431110,-0.2585910,-0.8358290,-0.4079520, 0.1261590,-0.4070220,-0.9852030, 0.3750200, 0.3253390, 0.9597020,-1.0736240,-0.6108250, 0.0184900, 0.9296560, 0.4590870,-0.7315160, 0.8494000,-0.2463230, 0.4493910,-0.6211410, 0.3119980, 0.1193220,-0.7757620, 0.4118430, 0.3772810, 0.2427480,-1.1713280,-0.6178460, 0.5427350,-0.5036360,-0.3764680, 0.0625070,-1.4045360, 0.8299910, 0.0693700,-0.8018040,-0.1537230,-0.3694970, 0.4743610, 0.1015960, 0.2319070, 0.1413840, 0.2215220, 0.3585670, 0.8806940, 0.3895060,-1.1315160,-0.4390190,-0.6370740,-0.6999590,-1.2354240,-0.9135730, 0.8481120,-0.0677890,-0.1143390,-1.0497700,-0.7361410, 0.0629940,-0.8513810,-0.0327770,-0.2242580,-1.1020410, 0.0731370, 0.3750020, 0.0391330,-0.2370980,-0.9177010, 0.8520740, 2.0410140, 0.2066100, 1.0150070, 0.8105150, 0.2586990,-0.4375790, 0.3046380,-0.2585200, 0.5051330, 0.4002300, 0.7170690, 0.1926070, 0.7817390, 0.9011470, 0.2477310,-0.8829620,-1.2349150,-0.6159270,-0.0360560,-0.6304340, 0.2735920,-0.2413690,-1.0461090,-0.9906000,-1.3377140,-0.1645890,-0.7718180, 0.7029980, 1.0661900, 0.6591630,-0.3900540,-0.5790010, 0.4296750,-0.2853290, 0.1683550,-0.9870900,-0.4934550, 0.2625490, 0.2771720, 0.6085380,-0.1236180,-0.1849880, 0.9175380,-0.3260630,-1.3157670,-2.1407560,-0.3603180,-0.3502740,-0.7059140,-0.6286420,-0.0881960,-0.4877850, 0.3131520, 1.1092790,-0.0656140, 0.7858490, 1.1130130,-0.4221640, 0.3814350, 0.5863290,-0.0034090,-0.0645690, 0.0600660, 0.2037670,-0.2659720,-0.3227700,-0.3825960, 0.6493060, 0.2435400, 0.7957090, 2.0712580, 1.2429850, 0.1998530,-1.6727100,-1.2313410,-0.4086670,-0.1590990,-0.3723750, 0.2557600, 0.3432700,-0.7894090, 0.5545480,-0.4397160, 0.0887930, 1.6173380,-0.2274170, 0.8919580,-0.6065330, 0.3235210,-0.4069950, 0.8451630,-0.2522080,-0.1604960, 0.4552880, 0.7913300, 0.6127800, 1.7747530, 1.5049230, 1.7798030, 2.1784610, 2.0400630,-1.0711170,-0.6355870,-0.3832590,-0.4534150,-0.0479090,-0.1085810,-0.1711980, 0.0523820,-0.3634530,-0.4622900,-0.5334750, 0.2802040,-0.3205510, 0.5921720, 0.6996630,-0.4373610, 0.0851280, 1.0398890,-0.3005090, 0.9274230,-0.0994720, 1.4370430, 1.7547980, 0.1281560, 0.5611010, 0.7833390, 0.4070780, 1.2830590,-0.0883960, 0.3850540,-0.5821140,-0.2095860,-0.2095980, 0.0689110,-0.2159610,-0.1060730, 1.3485740,-0.4647540, 1.6533410,-0.3366790,-0.3209350,-0.7755950,-0.6976570, 0.0668720, 0.5772390, 0.6594860, 0.1541250, 1.4513180, 1.6140200, 1.9458000,-0.0346110, 1.0966060, 0.5686240, 1.6765880, 0.7660190, 1.1263240,-0.5382170,-0.3968810, 0.8747420,-0.1412100, 0.0598290,-0.0346420,-0.3055480,-0.2013200,-0.1072560, 0.5471720, 0.5138020, 0.5120660,-0.7405650,-0.1134400,-0.3898920,-0.0365570,-0.1701440, 0.6682890,-0.0694100, 1.1215090,-0.8942470, 0.6919140, 0.6293970, 0.2781500,-0.1323770,-0.0247790, 1.4335270, 1.3105330, 0.6493680,-0.7621360,-0.0309960,-0.3745240, 0.5285740,-0.3404360, 0.7892280, 0.1135850, 0.5766720,-0.5509560,-0.0735420,-0.0427030,-1.1026810,-1.1875670,-0.7396140,-0.6755220, 0.0898060, 0.0523180, 0.1987660, 0.1114360,-1.4478380, 0.3341640,-0.3552220, 0.2896170, 0.1501590, 0.2461640, 0.2918860, 0.6895270,-0.2790850,-0.0891220, 0.1243460, 0.0998620,-0.2449620,-0.5766910, 0.0607790,-0.6828660,-0.0938870, 0.5348330, 0.2017380,-0.0069100, 0.4644600,-0.6209880, 0.1606210,-0.8588970,-0.4940560,-0.6836510, 0.4001300,-1.5330300,-0.0125390,-0.1551330, 0.0522990,-0.1786060,-0.5429270, 0.3848390, 0.4038060, 0.8474200, 0.3180120,-0.3548210, 0.5740080,-0.3586310, 0.9053740, 0.1873980,-0.1037820, 0.6764220,-0.6864820, 0.1223570, 0.0021360,-0.0294030,-1.1505310,-0.6648710, 0.0300550,-0.7827000, 0.0434520,-0.3252120, 0.2245210,-0.5375260, 0.6834990,-0.3795240, 0.7507050,-0.0083500, 0.0925540, 0.5398450, 0.2285280,-0.4964390, 0.4518180, 0.0503930,-0.1192140, 0.1101360,-0.2926500, 0.2731520,-0.0872610,-0.1110990, 0.0114140, 0.9016460,-0.3129630, 0.7205180,-1.0189430, 0.5951320, 0.2159870,-0.5615130,-0.3280070,-0.4876670, 0.1557060,-1.2497540,-0.2710310, 0.4864760,-0.7266110, 0.1391270,-0.0471100, 0.4071560,-0.3873220, 0.3930260, 0.1852030, 0.2748180,-0.2010880,-0.6610160, 0.1795990,-0.7942550,-0.7704060, 0.3478360,-1.3851100,-0.6450510,-0.4676250,-1.4404570,-0.9188880, 0.2419220, 0.6215110, 0.1421000,-0.5227880, 0.7235240,-0.7098900,-2.5266450,-1.1970830, 0.0268710,-0.1088170, 0.5772330,-0.1778650,-0.2493880, 0.6928880, 1.3654810,-0.7308950,-0.0314940,-0.4320970, 0.4598410,-0.5257090, 0.4003600, 0.3575370,-0.4459970,-0.2495910,-0.3237480, 0.7155430,-1.2387210,-1.8871630,-0.6881190, 0.0873670,-0.8520000, 0.4381420,-0.6867690,-0.7897240,-1.4243960, 0.1335220,-0.6141840,-0.9460440,-0.6539780, 0.2995320,-0.3840130, 0.0741360,-0.1936040, 0.2329300, 0.0984710, 0.7195480,-0.4482970,-0.4177290,-0.6596200,-0.3744100,-0.5869480, 0.6157990,-0.8996040,-0.4581210,-0.6793500,-1.4933990,-0.0062510, 0.0805820,-0.1679000,-0.8785280, 0.2334860, 0.7494420,-0.7929850, 0.7782060, 0.2813070, 0.1495820, 0.0150110,-0.7192660,-0.2001740,-0.0126630, 0.2116810, 0.2024390, 0.5153290, 0.0230480, 0.2911180, 0.3969950,-0.2936380,-0.6434690, 0.5744100, 0.8536100, 0.1053860,-0.1251430, 0.4419170, 0.2790850, 0.3256270,-0.3281030,-0.3015000, 0.3514940, 0.4102390,-0.8610000,-0.5907430,-0.7082060,-1.6986360, 0.3930710,-0.8254860,-0.3099150, 0.4335430,-1.0026290, 0.3780370,-0.2341480, 0.4724480,-0.6014040,-0.2009600,-0.1652910, 0.0526340,-0.6028000,-0.7066360,-1.1233950,-0.4164090, 0.0272550,-0.2769570,-0.1480360, 0.1210520, 0.8250940,-0.7359000,-0.7978000,-0.7918580,-0.5956120,-0.9375320,-0.0568860,-0.0160240,-1.1081950, 0.8937810,-0.0610060,-0.2664690, 0.3649980,-0.4914400,-0.2551380,-0.8204160, 0.2939560, 1.2371010, 0.0079850, 0.2379750, 0.0073110, 0.4528820,-0.5432960,-0.6004520, 0.2867610, 0.1485740,-0.3709670,-0.5724530,-0.5291000, 0.2270000, 0.0388000, 0.7163690,-0.0466840, 0.3054800,-0.4365600, 0.3039490,-1.3379170,-0.5644980,-0.8037860,-0.2644540, 0.9339300,-0.3948600,-0.1538550, 0.1235900,-0.7472990, 0.4393500,-0.0584870, 0.6249140, 0.9294100, 0.7370700,-0.1923630,-0.3003700, 0.9030810,-0.0935070,-0.3738710,-0.9636480,-0.1580000, 0.8606000, 0.6011000, 0.4157820, 0.1860600,-0.1811090, 0.0291900,-0.0233190,-0.3126160,-1.4831920, 0.5940020,-0.1856450,-0.9382700,-0.8239280,-0.9683340,-0.1818860,-0.8682270,-1.1251660,-0.2348650, 0.2517250,-0.0047030, 1.4997140, 0.7079890, 1.2869610, 1.0258620, 0.0417070, 0.0945850,-0.6183650,-0.8002000,-0.3616000, 0.8831000, 0.4750000, 0.7729130, 0.8241140,-0.0898600,-0.8532920, 0.8295950,-0.1889410, 0.1465370,-0.4512470,-0.0054090, 0.7873010,-0.2396730,-0.2456590, 0.1463160,-0.6888590,-0.1347960, 0.4212540, 0.5446680, 1.0451070,-0.3547650,-0.5223730,-0.0374130,-0.8600050, 0.2520690, 0.7666000, 0.8182000,-0.8232000, 0.5030000,-0.7804000, 0.4355000,-0.4586000,-0.1705780,-0.4959600, 0.1365530, 0.6424590,-0.1758970,-0.0787370,-0.4735360,-0.7318640, 0.4107240, 0.8130030, 0.3421320, 0.8882470, 0.6750880,-0.0657240, 0.5841430, 0.0114260, 0.8151990, 0.4075030, 0.8900400, 0.5333000,-0.0703000,-0.6065000,-0.6068000,
 0.4935000,-0.3877000, 0.7325000,-0.3025000, 0.1096000,-0.6662000, 0.7983000,-0.1985000, 0.7875000, 0.0094000, 0.0271000, 0.0860000,-0.1182760, 0.8366120,-0.8866910, 0.6534650,-0.6814000, 0.2661000, 0.4784000,-0.5394000,-0.5056000, 0.0547000,-0.0071000,-0.6286000,-0.5731000,-0.7129000,-0.0975000,-0.7384000,-0.7953000,-0.7701000, 0.8021000, 0.5261000,-0.4274000,-0.7810000, 0.4958100, 0.0876060,-0.0694320,-0.7505360, 0.2448670, 0.7582760, 0.4929810, 0.0861860, 0.4676400,-0.0376170,-0.2674750, 0.6882320,-0.2277530, 0.0717110, 0.7997060, 0.6439740, 0.6720590,-0.6329560, 0.3513000, 0.8328000, 0.7988000,-0.4612000, 0.5193000, 0.4610000,-0.6294000,-0.0768900, 0.3235210, 0.6373160,-0.2976520, 0.6442630, 0.1225760, 0.5907210,-0.3628640,-0.1889990,-0.4172220, 0.0496180,-0.1170500,-0.8131330,-0.8622500, 0.6643450, 0.0080150, 0.5122300, 0.6319350,-0.7488890, 0.5756580,-0.4047670, 0.3295970, 0.6830950,-0.6441000,-0.5401000,-0.5412000, 0.5350000,-0.7257620,-0.3583020,-0.6783170, 0.0565310, 0.4814580, 0.3853930, 0.9923120,-0.0961430, 0.1810060, 1.5419970, 0.6817010, 1.6291210, 1.7112220, 1.3479500, 1.3130170, 0.3191470, 0.8178890, 0.8774090, 0.6048840, 1.0413100,-0.4595090, 0.7152520,-0.0205300,-0.5158790,-0.0752460, 0.4867000, 0.8309000, 0.6827000, 0.4294000, 0.5146670, 0.4175360,-0.6187490, 0.4735970, 0.8963200, 0.8823290, 1.4255160,-0.0325100, 0.4426640, 0.2559060, 0.5260140,-0.3055000, 0.3320690, 0.1742750, 0.4454280, 0.2427620, 0.3706490,-0.8322300,-0.0600040, 0.5114090, 0.2711530,-0.1511180, 0.0946140, 0.3881880,-0.2384540, 0.2782000,-0.4416000, 0.5201000, 0.6731640,-0.7409470, 1.0911260, 0.9257760, 0.0159930, 0.5987620, 0.8443910, 0.5624370,-0.8960320,-0.3865180, 0.4500550,-0.3059880, 0.0211900, 0.1926850, 0.0489580, 0.3881640,-0.3101000, 0.8202860, 0.6071850,-0.4892230, 0.6098390, 0.4160210,-0.1882650, 0.1846320, 0.5355320,-0.4795000,-0.8292000,-0.4983760,-0.7229310,-0.0260730, 0.5106390,-0.0588030,-0.2412460,-0.7900330, 0.3950960, 0.7041220,-0.7079810, 0.5030040,-0.2410290, 0.4952760,-0.3594700,-0.1973150,-0.3479730,-0.3657320, 0.2701840,-0.0466580, 0.0431770, 0.1928050,-0.0158660, 0.4194210, 0.4779590, 0.3173470,-0.3186130,-0.8358390, 0.6039290,-0.6246000, 0.2516710,-0.0548410, 1.4253860, 0.3584300, 0.3562020, 0.3054020, 0.3691060,-0.2208380, 0.9006230,-0.3607020, 0.0836420, 0.5879030,-0.7655800, 0.4370840,-0.4445210, 0.4525970,-0.5855980, 0.4312160,-0.5042340, 0.0345900,-0.0779510, 0.6988110, 0.8390180, 0.3748770,-0.5027110,-0.7048970,-0.1261680,-0.2434540,-0.0434540, 0.3202880, 0.1493670,-0.3435560, 0.1171350,-0.4663450,-0.0654270,-0.1344540, 0.2564800, 0.0906020,-0.3241700, 0.3401280,-0.2706750,-0.1391190,-0.0041930, 0.0697490,-0.4555410,-0.2169510, 0.1579670,-0.2216590, 0.9476310, 0.2064040, 0.3053210,-0.1157870, 0.8579670,-0.4419790, 0.6455720, 0.5994180, 0.3671950, 0.0686680, 0.1281690, 0.1827470,-0.6273230, 0.2061310,-0.1646020, 0.0818930, 0.5851130, 0.4180230, 0.4562640, 0.1478800,-0.2217970, 0.1917450,-0.5553990, 0.1353200, 0.5285510,-0.5546840, 0.0837200,-0.2692410,-0.4384810, 0.9290920, 0.3678670, 0.4834110, 0.2517210, 0.2458740,-0.0137240,-0.1887390, 0.6181710, 0.1094690,-0.5280570,-0.0526440, 0.4224850, 0.0129350, 0.2292060,-0.1098570,-0.1607410, 0.0967510, 0.9827560, 0.4504660, 0.4241530,-0.2730530, 0.1886300,-0.3700180,-0.3076630, 0.3690560, 0.9893230,-0.3234330, 0.6955140, 0.6596190, 0.5917640, 1.1612820, 0.9431360,-0.5086530, 0.0729520, 0.6396580,-0.6248670, 1.2865360,-0.0227980, 0.4145840,-0.2986020,-0.6666790,-0.2782930, 0.1564280,-0.1555600, 0.9064680, 0.4050640,-1.8085370, 0.0862920,-0.3717830, 0.1313410,-0.4082440, 0.0299420,-0.3927990, 0.0517850, 0.5679680,-0.2421440, 0.1122510,-0.2770650,-0.1478520, 0.7602720,-0.2630490, 0.3794980,-0.7737780, 0.6465880, 0.1345040,-0.3494700,-0.6805520, 0.1161920, 0.5994240,-0.4637740,-0.1142350, 0.4739900, 0.4731720,-0.7020120,-1.1858040,-0.4226340,-0.1358010,-0.3579390,-0.2252520,-0.6867450,-0.6987080,-0.7859110,-1.7188660,-0.3721780,-1.4837960, 0.5193070, 0.8228670,-0.6922400, 0.6558040, 0.0217560,-0.4369530, 0.4589160, 0.0303200, 0.5322510, 0.1311280,-0.2545770, 0.0029970, 0.3586490, 0.1982930,-0.2173590,-0.4890890,-0.3118650,-0.8588420,-0.5251380,-0.2793460,-0.3407700,-0.0862970,-0.5240290,-1.3088230,-0.5645680,-1.9669640, 0.0934160, 0.1584740,-0.2920050, 0.4590340,-0.5369450,-0.2470860,-0.6619500, 0.7574700,-0.0927090,-0.5478920,-0.0034260,-0.3886850, 0.4064330,-0.1733920,-0.3359940, 0.5560380,-0.9499480,-0.5219670,-0.7954130,-1.1562980, 0.0692080,-0.8257380,-0.4931360,-0.5653530, 0.0677920,-0.4305370,-0.2832720, 0.4105290, 1.1787050, 1.1285290, 0.2319830,-0.2142760,-0.7866350,-0.7524620, 0.1472890,-0.5990540,-0.2855110,-0.2457840, 0.3282790, 0.1057990, 0.4898860, 0.4622560, 0.2376350,-0.0811430,-0.1411770, 0.0814580,-1.3576490,-0.8053280,-0.1183080, 0.0935380,-0.2888570,-0.1911300,-0.4003050, 0.1136310, 0.9840850, 1.4580990, 1.5437050,-0.1515160,-0.5788890, 0.7615210,-0.0720700,-0.4305020,-0.6483860, 0.0851380, 0.4093120, 0.8161190,-0.4161240,-0.1517910,-0.3555590,-0.0622020,-0.3375680,-0.8642390, 0.0962690,-1.1537580,-0.2447110,-0.3471490, 0.1661860, 0.0322030, 0.0361880, 0.1736320, 1.1234570, 1.5300630, 1.7851610, 1.0713180, 0.5526100, 0.2445540, 0.4616140, 0.0422210,-0.0627410, 0.2418000,-0.7454930,-0.8164440,-0.0359180, 0.1544780, 1.1049200, 0.2067420,-0.3770380,-0.1770630,-0.1161790, 0.1938140,-0.0027700,-0.5880730,-0.3606920,-0.8253420, 0.5681160,-0.7558940, 0.3099970,-0.0094320, 1.5233590, 0.7994010,-0.2022890, 0.5802790,-0.2747430, 0.0255090, 1.1511290, 0.3926730,-0.2515020,-0.2588580, 0.7401480,-0.4980940,-0.2004970, 0.9494480, 0.7149330,-0.8544600, 0.0105690,-1.4477110, 0.2679750,-0.9712900,-1.0716240,-0.4066240, 0.4152330,-0.6862750,-0.5782450, 0.6062170, 0.8004670, 1.6331180, 0.0498830, 0.1427330,-0.1515140, 0.5402930, 0.4199900, 1.0910300, 0.3851450, 0.3179310,-0.3002290,-0.3717000,-0.9194900,-0.7643400, 0.0469360, 1.7183540, 0.7982790, 0.0138080, 0.2430010,-0.4155450,-0.6885910,-1.1252820,-0.1639110,-0.6092280,-0.3576560,-0.0215930, 0.8570580, 0.7843270, 0.2442080,-0.4296960, 1.1079420,-0.3466990, 1.5133980,-0.4194670, 0.4514080, 1.2549190,-0.2664290, 0.0322030,-0.4253120, 0.0371000, 0.1764210,-0.5833020, 1.4542870, 0.6177740, 1.0805820, 0.5755180,-0.3628490, 0.4978300,-0.1566810, 0.2533770, 1.0494540, 0.8771140, 1.5865330, 0.7363470,-0.5204690, 0.6984470, 0.2826850, 0.3166470,-0.1559610, 0.1413910,-0.6002220, 0.1433130, 0.9236130,-0.3299060, 0.5325430,-0.6400040, 0.2573600, 0.0533000,-0.4029670,-0.5868890, 0.5551680, 0.5789370,-0.6430780,-0.6084500, 0.0998560, 0.2889610,-0.2616610, 0.7670350, 0.9571860, 0.7975600, 0.3178130, 0.0734970, 0.2169720,-0.2412250, 0.3165760, 0.2008480, 0.2617440, 0.0320690,-0.1646120,-0.2899710,-0.5840760,-0.0731750, 0.5111980, 0.2471450,-0.0870000,-0.8430000,-0.2885720, 0.2779640, 0.5110620, 1.1308810, 0.2766200, 0.1853000, 0.1962010,-0.1610310, 1.0301050,-0.0533300, 0.2615220,-0.1009060,-0.3141830, 0.2720210,-0.2942140,-0.4532860, 0.0815250,-0.7420020, 0.2296770, 0.5544040,-0.4763990, 0.1110520, 0.5815360, 0.0107450,-0.3251110,-0.3701810,-0.5306000,-0.7662000,-0.7942000,-0.3606780, 0.4382150, 1.2086150, 0.8498230,-0.6965720, 0.5509870,-0.0037670, 0.1831070, 0.6044900,-0.0517440, 0.4347890, 0.1024870,-0.0211790, 0.5362230, 0.1192770,-0.4303930,-0.6904900,-0.0660190, 0.0403700, 0.2843500, 0.5950230, 0.0886870, 0.1342920,-0.5382350, 0.6176950, 0.8047000,-0.7305000, 0.7921000,-0.4788390,-0.1926830, 0.3745060, 0.0925070,-0.3551330,-0.5634180, 0.2474490, 0.6628500, 0.1968680,-0.2571820, 0.6740800, 0.6423170, 0.5640200,-0.0305750,-0.1530810, 1.1161430, 0.3778500,-0.1793530,-1.6723130, 0.1448380,-0.3957070,-1.5013590, 0.3483050,-0.8903510, 0.4637430,-0.1787000,-0.5489000, 0.1610000, 0.8313000,-0.1168690, 0.5056440,-0.3710080, 0.7541930, 0.3174080, 0.5310950, 0.2494650, 0.4264710, 0.8632190,-0.0375140, 0.4308340, 0.0934290, 1.1585100, 0.3855480, 0.1023830,-0.0598200, 0.1050000,-0.2840200, 0.6263850,-0.3999950,-0.4774750,-0.2989750,-0.6995540, 0.7763510,-0.3540000, 0.1758000,-0.5146000, 0.1008000, 0.2435260, 0.4033590,-0.6326570,-0.2967830,-0.0366950, 0.6721040,-0.0179710, 0.4582560, 0.5687180,-0.0322530, 1.2655320,-0.3639590, 0.8438870, 0.0161720, 0.4598630, 0.2902010, 0.6759290,-0.5297410,-0.0355400,-0.5009200, 0.6750640, 0.1068760,-0.4346090, 0.6340000,-0.2294000, 0.1325000, 0.5165000,-0.6601000, 0.4116000,-0.3005220, 0.0781980, 0.6791430, 0.4960660, 0.9751610, 0.0988300, 0.1068480,-0.0394770, 0.2752400, 0.3360830, 0.7539040, 0.4685710,-0.4547050, 0.6473860,-0.2699150, 0.6848190, 0.3610500, 0.4846260, 0.3192050,-0.1561560, 0.4386000, 0.2300000,-0.5927000, 0.7045000,
 0.8514000, 0.3013000,-0.7641000,-0.0367000,-0.4363000, 0.5179000, 0.2398000, 0.8080000, 0.8187000,-0.8363000,-0.4439000, 0.1303000, 0.5364060,-0.2147500,-0.4622470,-0.7817990, 0.1873000,-0.6980000, 0.4509000, 0.3261000, 0.5509000, 0.0962000, 0.4384000, 0.3651000, 0.6590000, 0.8398000, 0.2766000, 0.4426000,-0.7894000, 0.3925000, 0.8730000, 0.3677000,-0.2443990, 0.8519040, 0.4509360,-0.3988330,-0.3432030, 0.5453340, 0.9024010, 0.4207900, 0.4554640, 0.7565030, 0.3872130,-0.6936100, 0.2100190, 0.5880170,-0.7332230,-0.2823330, 0.1567620, 0.2945640, 0.5605640, 0.2365180, 0.6790000,-0.0188000,-0.7465000,-0.1448000, 0.7629000,-0.2293000, 0.2042030,-0.4090280,-0.6697760, 0.7002280, 0.7612880,-0.4144130,-0.5925780, 0.4296550,-0.1860960, 0.7742890, 0.7287000, 1.2042730, 0.7454660, 1.5797620, 0.4221520, 1.7875650, 1.0711740, 0.7440790, 0.7208430, 0.5262870,-0.2984910,-0.5977340, 0.7025840,-0.3325720,-0.6107000,-0.1770000, 0.7324000,-0.2636000, 0.5886060, 0.5847420, 0.7115400,-0.2384780, 0.0255750, 1.1893590, 0.2676460, 1.8872670, 2.1233600, 1.6128140, 0.8186530, 0.5851600, 0.4253500, 0.7561730, 0.5835360,-0.5904580, 1.0146060,-0.0750310, 0.3657600, 0.3788240, 1.1668400, 0.7551900, 0.2337860,-0.2313060, 0.2456950,-0.3782000,-0.4080000, 0.1219300,-0.1591850, 0.5876120, 0.4203290, 0.1918230, 0.0923370, 0.5208820, 0.4744300, 0.0121790, 0.6458110,-0.8765090, 1.0100160,-0.4715380, 0.3066690,-0.5733330,-0.1522030, 0.2835850, 0.1050880, 0.3055730,-0.0984290, 0.3253830,-0.3466740, 0.0666760, 0.4186960, 0.5152030, 0.0316130, 0.7251020, 0.6064000, 0.7838000,-0.4487090, 0.3203520, 0.5321860,-0.4810280, 0.6000010, 0.5640980,-0.5781750, 0.6535950,-0.7711480, 0.7349440, 0.7435490,-0.5256570, 0.1057290, 0.6192230,-0.2031880, 0.1677900,-0.5920750, 0.2496140, 0.2547910,-0.4627940, 0.8250860,-0.3565910, 0.4606760, 1.0590540, 0.4941560,-0.4252770,-0.6586000, 0.5332000,-0.5115170,-0.5965430, 1.0318840, 0.6027690, 0.7163350, 0.0441170,-0.1682230, 0.5765310,-0.0278950, 0.2106980,-0.4049980, 0.1068740,-0.2187850, 0.0997270, 0.4464750,-0.3593690,-0.0974510,-0.1274990, 0.1038540,-0.9496610, 0.4408620,-0.3278220, 1.7534610, 0.9902120, 0.5178750, 0.5362190,-0.1823970, 0.1091590,-0.5054820,-0.0567400,-0.0033080, 0.0320120,-0.1487160, 0.0613270, 1.2219080,-0.5006900, 0.2032210,-0.5236380, 0.8439570,-0.1301590, 0.2107060,-0.5039440, 0.1662190,-0.4387670,-0.0310060,-0.8123500, 0.1148790,-0.0322620,-0.0201990,-0.4776070, 0.7193430, 0.6120100, 0.4939960, 0.8700370,-0.0359390,-0.8673250, 0.2754000,-0.1461310, 1.3067820,-0.6097710,-0.8999400, 0.0085190,-0.5422060,-0.0778990, 0.0130470, 0.2346180,-0.9017430, 0.5080630,-0.4505560, 0.2963100,-0.4811120,-0.5542050, 0.1114260,-0.0969920, 0.0787860,-0.5272970, 0.4411030,-0.7214080, 1.3770380, 1.1762990, 1.0158960,-0.1413470, 0.1670280, 0.8959300,-0.2651650,-0.1392050, 0.7963300, 0.0993860, 0.9814820, 0.3628060,-0.0673820, 0.3591350,-0.8314750, 0.5837900, 0.0572800,-0.1387790, 0.1228550, 0.3362900,-0.3531530, 0.1210000,-0.7273590,-0.2513760,-0.3746990,-0.1894230,-0.1785930,-0.6372230, 0.1024740, 1.2801210, 0.2459870,-0.4422190, 0.3138780, 0.1708830,-0.7417950, 0.6550040, 0.0586830, 0.1077220, 0.7248410,-0.2577470, 0.3243860,-0.0375090,-0.2565760,-0.2519480,-0.3478450, 0.0313430,-0.0326620, 0.5793390, 0.1169810,-0.3699220,-0.5112320, 0.0235300, 0.1537970, 0.0236200, 0.0986200,-0.8694620,-0.2606540, 1.2029770, 0.8054710,-0.3141720,-0.2066240, 0.2525890,-0.6756400, 0.7696450, 0.8338180, 0.1523510,-0.9750850, 0.2256510, 0.2170200, 0.3625230, 0.5381760,-0.7798480, 0.4165920, 0.4226890, 0.2780430, 0.2944010, 0.6055760,-0.0938580, 0.3286610,-0.3296980, 0.2854450,-0.7903950,-0.2982750,-0.1395820,-0.1562170, 1.2576570,-0.0298250,-0.8063340, 0.5364150, 0.4839200, 0.2051840,-0.0226990, 0.7813930,-0.1847480, 0.0094270,-0.3657510,-0.8028640, 0.4560220,-0.3510540, 0.6521590,-0.4718470, 0.3154380, 0.1220980, 0.9535410, 0.7925310,-0.3170620,-0.2696850, 0.1230480,-0.7722020, 0.2384630,-0.2497030, 0.1894040,-0.3810930, 0.4759870, 0.1514890,-0.2269660, 0.1203980, 0.1964130,-0.4656020, 0.9645530,-0.1336240, 1.2128470,-0.7397190, 0.6693530,-0.1787110,-0.1232520,-0.7862380, 0.4761400,-0.1703600, 0.7011040, 0.5106920, 1.1740050, 0.1957030,-0.4279390, 0.2897400,-0.1628630, 0.5568630, 0.0629600,-1.0103180,-0.5929290,-0.1225870, 1.0064980,-0.1756500, 0.7311760, 0.6184000,-0.4688590, 0.0027630, 1.2591680,-0.2087780,-0.9157690, 0.1251050,-0.6551500, 0.4056180,-0.1789110, 0.4164440, 0.3876590,-0.6328540, 0.2040560, 0.6355480, 0.3465930, 1.0123880,-0.0614950, 0.4362100, 0.5681330,-0.8278270,-0.1041310, 0.3804840, 0.1989620, 0.5103480, 0.2721460,-1.1163590,-0.7218400, 0.0154000, 0.3951780, 0.3718150,-0.0150400,-0.0516600,-0.3929380, 0.4303010,-0.6370350,-0.3626650,-0.5632960,-0.0156030, 0.3878800,-0.1606930, 0.3801770, 0.6911630, 0.9297360, 0.1742210, 0.4213400,-0.0612540,-0.0999840,-0.2227290,-0.2313590, 0.2320670,-0.4771870,-0.8081570, 0.5712620,-0.3313600,-0.9342670,-0.4562970, 0.3438770, 0.0011550, 0.2945140,-0.1929710, 0.1499330,-0.3603140,-0.1398170,-0.1224070, 0.1652420,-0.6200490, 0.0258070,-0.1617180, 0.4165930, 1.6157440,-0.0646540,-0.0148280, 0.0047110,-0.4560520, 0.5012590,-0.0713870,-0.4330660,-0.6282560, 0.3009700, 0.3294240,-0.1014250,-0.0782970, 0.3150570,-0.0060000, 0.8777300, 0.0122400, 1.4258890, 0.5203730,-0.0454730,-0.5228580, 0.0415750,-0.4025500, 0.0817060,-0.5493010,-0.1301180, 0.4510640, 0.2049020, 1.6051170, 0.5801930, 0.3626300,-0.0044490, 0.3414500,-0.2926410, 0.3555670, 0.5202450,-0.5762940,-0.3181610,-0.5940680,-0.0323140,-0.3138610, 0.6810430, 0.2356700, 0.3401670, 0.4118780, 0.5680790, 0.3358880,-0.0488810, 0.4508210, 0.0291700,-0.3060550,-0.3568290,-1.0951640,-0.6269050, 0.0311090, 1.1796630, 0.0513560,-0.1095280, 0.3024860, 0.3749700, 0.1030210, 0.2882510, 0.3324900, 0.3401490,-0.0022860,-0.1478310,-0.2903220, 0.2956730,-0.6008840, 0.8775010, 0.7367970,-0.6320940, 0.5284520, 0.8089970, 0.8909140, 0.9498530,-0.0996400, 0.0656660,-0.2976870, 0.4859770,-0.8365580, 0.2572340,-1.0658160, 1.6417600, 0.2543160, 0.0007180, 0.2812970,-0.1245210, 0.2061510, 0.1007260, 0.2791700, 0.5725290, 0.2826780, 1.3641170, 0.5654530, 0.3736320,-0.9273500,-0.6543900,-0.2319000,-0.1370490, 0.9707530, 0.9202720,-0.2942020, 0.1820180,-0.6611830,-0.1433500,-0.5284230,-0.2673060,-0.2505090,-1.0276580, 0.9206780,-0.2461050, 0.6752220, 0.1551760, 0.6582490, 0.0981140, 0.4401040,-0.4787700,-0.0487280,-0.7289250, 0.6729200, 0.6491970, 0.5388570, 0.3829840,-0.9328550, 0.1532020,-0.1659050,-0.3377790,-0.1544430, 0.6724140, 0.4423070,-0.8950790,-0.3079480, 0.6509340, 0.5336160,-0.8168830,-0.0486060,-0.3574420,-0.1572100,-0.1172560,-0.4065700, 0.4129640, 0.0472200, 0.4123380, 0.8785360, 0.8068850, 0.4452820,-0.2702760, 0.5571800, 0.9502460, 0.6369570,-0.0776860, 0.0389900,-0.4176060,-0.5700050, 0.4714990, 0.5441060, 0.3734620, 1.0873920, 0.0485610, 0.0216940, 0.2451750,-0.5531490,-0.3832380, 0.8379450,-0.3219800, 0.1397290,-1.1301310, 0.8422960,-0.3338930, 0.2268740, 0.0593120,-0.1906670,-0.0106550, 0.5818020,-0.2433110,-0.9235160, 0.0653030, 1.2516100,-0.5497770, 0.7092370, 0.6651880,-0.2996000, 0.4655000,-0.1870770,-0.1785820,-0.2839910, 0.8117250,-0.6274590, 0.5502940,-0.2710700,-0.4207410,-0.4557440, 0.2093360,-0.5286000, 0.2769190,-0.0864930, 0.3746890,-0.3459980, 0.0988690,-0.3844320, 0.5356000, 1.3034120, 0.3138840, 0.6357230, 0.1860660,-0.0873800, 0.1759570, 0.6327200, 0.3987000, 0.1797000, 0.3052000, 0.5867880, 0.2071540, 0.5373070, 0.7056820, 1.3726390, 0.0420690,-0.1052300,-0.7148050, 1.2631450,-0.1732880,-0.3103120, 0.1441370, 0.0422050,-0.4618810, 0.5299600, 0.4404410, 0.6191980, 0.2377370, 0.1071650, 1.0712760, 1.1889710, 0.0425860, 0.2792760,-0.5483520,-0.6174950, 0.4236000,-0.4716000,-0.6460000,-0.5401540, 0.6115800, 1.0218760, 1.4271040, 0.3813510, 2.5517470, 1.9156380, 1.3151080, 1.8919780, 1.0350220, 2.3723000, 2.4936590, 0.8023010, 2.3020970, 0.3255120, 1.9399670, 1.6316110, 0.8410870, 0.8871430, 1.4174350,-0.4254510, 0.5418220,-0.5516130, 0.7060430,-0.4874350, 0.5338000, 0.5288000, 0.2330000, 0.7960000, 0.0061020, 0.8744450,-0.5047380, 0.8848230,-0.0297730, 0.4591180, 1.2793130, 0.6387160, 1.2815700, 0.1282500, 0.3110710, 0.9732360, 0.3951340, 1.3090540, 0.2022270, 0.1812700, 0.1867360, 0.8349960,-0.2890340, 0.8938770,-0.1582060,-0.7915000, 0.3097120,-0.5078000,-0.4529000,-0.7660000, 0.2385000, 0.2351000,-0.8689000, 0.0085070,-0.4921540, 0.6264790,-0.7548580, 0.6612610,-0.1917220, 0.1521820, 0.1724780,-0.6070740, 0.7916800, 0.0391950, 0.1507680, 0.4966480,-0.1732520,-0.2492720,-0.7689390,-0.6113570, 0.3244820, 0.4300120,-0.8252410, 0.0560000, 0.2710000,-0.8026000, 0.3178000,
 0.3281000, 0.0711000,-0.1024000,-0.3235000, 0.7765000, 0.1721000,-0.7519000, 0.2709000,-0.7536000,-0.0940000,-0.3907000, 0.8319000, 0.2057310, 0.4848480, 0.0911400, 0.0595000, 0.4783000, 0.7835000, 0.0633000, 0.6090000, 0.2551000,-0.1122000, 0.2441000, 0.3453000,-0.2388000,-0.6255000,-0.7248000,-0.1585000, 0.7869000, 0.1778000,-0.0250000, 0.6375000,-0.5903000,-0.6150970,-0.2187990,-0.3413730, 0.6994280,-0.8390050,-0.0081060,-0.0849050, 0.5649720, 0.5701810,-0.1377650,-0.3378740,-0.7429270,-0.2848870,-0.0986820,-0.2285760,-0.7091870,-0.6331860,-0.4242760, 0.1711910,-0.6923000,-0.5116000,-0.8373000,-0.4598000, 0.7269000, 0.4522000, 0.8153000, 0.5019500,-0.0038990, 0.3080580, 0.3904610,-0.0186950, 0.8305620,-0.1229480, 0.5456060,-0.0369920,-0.0341440,-0.3118940, 0.4112600, 0.5908740, 0.1267940,-0.6296210,-0.8400390, 0.6673100,-0.8447760,-0.3990340, 0.1012320,-0.8735900, 0.3697750, 0.4008870,-0.3597000, 0.4949000,-0.3011000, 0.7025000, 0.4285780, 0.8207770,-0.6769800,-0.6570290,-0.1432350,-0.5628530,-0.6110680, 0.6900710, 1.3006710,-0.0292410, 0.0222970, 1.4248350, 0.3366270, 0.4795740, 0.6856220, 1.3186700, 1.0752920, 0.8267710, 0.2154980, 0.2595720,-0.6944100,-0.9697270,-0.5559820,-0.5164840,-0.5008770, 0.1574000,-0.6392000, 0.7706000,-0.7714360, 0.4895960,-0.2647380, 0.4948010,-0.8421990,-1.1817390,-0.0531290, 0.3392500,-0.4925840,-0.7827190, 0.3823880, 0.1891600, 0.5495750, 0.2877300,-0.9971890, 1.1020310,-0.2433450,-1.5680590, 1.1236990, 1.7699560, 0.0901090, 0.3077550, 0.4411190,-0.1999870,-0.5323380, 0.4955570, 0.4107000, 0.3637000, 0.4619430, 0.6434220, 0.6509140, 0.2977970, 0.7231970,-0.5267260,-0.1717490,-0.1761210, 0.0630290,-1.4451890,-0.0018360,-0.6373000, 1.1085800,-0.1839020,-0.6618380,-0.1050920, 0.3276410,-0.6684150,-0.8080230,-0.2503250, 0.7160230,-0.4794400,-0.1381170,-0.6509060, 0.1537720,-0.5708310,-0.0799000,-0.2528000,-0.9097800, 0.7275880, 0.9770300, 0.0387810,-0.3505010, 0.5544010,-0.4508240,-0.1526600,-0.3947880,-0.3857410, 0.3885890, 0.6125060,-0.3831910, 0.3422330,-0.6950140, 0.9890510,-0.8280920, 0.6873320, 0.4059330, 0.8413240,-0.6032570,-0.7603630,-0.4886640,-0.6457480, 0.6213930,-0.4359160, 0.5143010,-0.0998070, 0.2809040, 1.1131570, 0.6058290,-0.0420590, 0.0232230,-0.1561440,-0.0849840, 0.0618190, 0.7058390, 0.3372590, 0.5991790, 0.0942710,-0.2413580,-0.0655330, 0.7462010,-0.3655940,-0.5254440,-0.9711290, 0.0524810, 0.4824290,-1.2263110, 0.6881740,-0.0742180, 0.0186680,-0.7372890, 0.3327940,-0.3629240,-0.7660230, 0.3002030, 0.2832450, 0.5208000,-0.8432210,-0.1922440, 0.5229460, 0.1775800,-0.6578580, 0.4436150, 0.6260460, 0.6072770,-0.9187640, 0.9117740,-0.0674830,-0.0480330,-0.7253910, 0.2610770, 0.0094920, 0.3968360, 1.0150080,-0.9544950,-0.4096280,-0.4829970,-0.8751860, 0.4043030, 0.5131370,-0.5883570,-0.1104300, 0.5208980, 0.0232450, 0.6730000,-0.6695930, 1.0748020,-0.7730330, 0.0601080,-0.8786770, 0.1660050, 1.2463500, 1.2393550, 0.8008480,-0.9755950, 0.2119030,-0.7392610, 1.0761930, 0.0226650, 1.3593020,-0.7172670,-0.4684970, 0.9277050,-0.6540570,-1.5757850,-1.4630290,-0.0379300,-0.1046530,-0.2556550,-0.3985730, 0.5226890, 1.0922370,-0.2169820,-0.0984230,-0.1330070, 0.0737090,-0.2090020, 0.6328140,-0.8197100, 0.2458820, 0.9789200, 1.1294130,-0.3618870,-0.2299170, 1.0231580, 0.1845740,-0.6007120, 0.6229460, 1.3556520, 1.0887270, 1.2972100, 1.3935760,-0.6895990,-1.2681200, 0.0487510,-0.6437200,-0.0217840, 0.5773120,-0.4543140, 0.1784650,-0.2938170, 0.1098360,-0.0064750, 0.4401220, 0.7378250,-1.0580110, 0.3603930, 0.8797120, 1.3169660, 0.4750800,-0.8666680, 0.6532640, 0.5715300, 1.5237190, 0.6807530, 0.4892540,-0.0699110, 0.9256790, 0.2027580,-0.6296860, 0.0583280,-0.4522740, 0.3658950,-0.1459290,-0.6303460, 0.8966760,-0.5062770, 0.4027050, 0.4169110, 0.2057750,-0.2874610, 0.2238330, 0.4221650,-0.5990480,-1.2512830, 0.4741970,-0.0377180, 0.1676280,-1.0701580, 0.7899640, 0.4353040, 0.1892800,-0.0999290, 0.9667880,-0.1272160,-0.7148300, 0.3557700,-0.9865660,-0.6489840,-0.6434600,-0.6518570, 0.1127170, 0.0464740, 0.2991270,-0.1308860, 0.3786280, 0.4315280, 0.5166210, 0.9276880,-0.1251080, 0.7471460, 0.3320460, 0.2255500,-1.1757090,-0.1689380, 0.0345590,-1.6250570, 0.1248840,-0.3457220,-0.3458000,-0.0601810, 0.4125760,-0.1425610, 0.1089780, 0.3777950,-1.1123800, 0.0242590, 0.5691150,-0.0345940, 0.3688210, 0.6978580,-0.6836340,-0.0498970, 0.2732110,-0.6906720, 1.0927250, 0.2594360, 0.1520490,-0.5718360, 0.2675860, 0.3292560, 0.1572200,-1.0034980, 0.0341660,-0.0472870,-0.3278720, 0.3493020, 0.8220720, 0.6595480, 0.5789200, 0.3693720,-0.6921320, 0.3309810, 1.1025800,-0.0704750,-0.6926320,-0.0004350,-0.6410590,-0.1498100,-0.5002490,-0.7803140, 1.0046650, 0.8438070, 0.3553920, 0.0447030,-0.3283760,-0.1430730, 0.8914660,-0.3042200,-0.3908540,-0.4405490,-0.9637490, 0.1691560, 0.2267950,-0.0568200, 0.7999020,-0.3001310, 0.6975090,-0.4620290, 0.6217280, 0.7343140, 0.5262240,-0.8266250,-0.4832040,-0.3578970, 0.6310070, 0.1734000, 0.1173240,-0.5890890,-0.5960530,-0.5298640, 0.0749760, 0.3147570,-0.7184920, 0.4937530,-0.1568240, 0.7444890,-0.0120600, 0.0872600,-0.5132440,-0.6890470, 0.5160000,-0.0837550, 1.0819510, 0.3691140,-0.0365510,-0.5886930,-0.3356530, 0.1489500,-0.4641950,-0.6552320, 0.8329500, 0.4392740, 0.0943430,-0.2518000, 0.2828070, 0.7107380,-0.0384600, 0.4571590, 0.2082960,-0.5865920, 0.0287910, 0.3675650, 1.1696140, 0.0869120, 0.9938880,-0.9874490, 0.0205890, 0.7197930, 0.2932940, 1.1114180,-0.7671960, 0.6346200, 0.1280620,-0.1012570, 0.0164380,-0.9935550, 0.2015690, 0.5209130,-0.2845340, 0.0546520,-0.6783150, 0.4530210, 0.7032130,-0.9855790,-0.9711820,-0.0396510, 0.3755690, 0.1265210, 0.6546570, 0.6199280, 0.5035710,-0.1104450,-0.0423080, 0.2665560, 0.1375130,-0.2124380, 0.4538220, 0.0574100,-0.3737480,-0.0539670,-0.3523490,-0.3839110,-0.5133170, 0.4150610, 1.3380140, 0.3501520, 0.1058420, 0.3251330, 0.4628830, 0.2011500, 0.4357570, 0.5583750,-0.3022590, 0.6900070,-1.6204650,-0.5302190, 0.4615110, 0.1551570, 1.1931420, 0.4529520, 1.5967180, 1.9427000,-1.1637680, 0.0154820,-0.1864590, 0.1574290, 0.2107100,-0.7281100, 0.1480550,-0.6236940,-0.3584770,-0.5390370, 1.2579960, 0.6968920, 0.8060380,-0.2578620,-0.1529540, 0.8743000,-0.6991630,-0.0953340,-1.0588280,-0.6090990, 0.6085410,-0.6494650, 0.0961760, 0.0112240,-1.1401870,-0.2082410,-0.6474750, 0.4175620,-0.1144360,-0.4605120,-0.5418240,-0.2424560,-0.8722420,-0.4659860, 1.3843190,-0.8969620,-0.6759120, 0.3394130, 0.7338510, 0.1248620,-0.6076170, 0.5157700, 0.8761380, 0.1712670,-0.8037080, 0.5805420,-1.4556730,-0.1695410,-0.3770170, 0.4409150,-0.3094110,-0.8079100,-1.2710210,-0.4856860,-0.1054400,-0.5075080,-0.3225970,-0.7906770,-1.5166520,-0.7984760,-0.8497480,-1.1679860,-0.6142120,-0.6968700, 0.0614300,-0.6159150, 0.8829280,-0.2972430, 0.4296340,-0.8837100,-0.1859390,-0.3799230, 0.2414240, 0.2857920,-1.6162450,-1.1569240,-1.0034060,-0.1970690,-0.5851780,-1.2981830,-0.3237330,-0.5214050,-0.9598730,-0.4501210,-0.1282910,-0.8649040,-0.3875330,-0.7500660,-0.6929490,-1.1474390,-1.1265680,-0.8926760,-1.3836270, 0.1567310,-0.7677960, 0.4477150, 0.2472680, 0.6461620, 0.6769180, 0.1902000, 0.7089000, 0.5188790, 0.0204910,-1.0620080,-1.2013380,-0.1696540,-0.4249430,-0.9749160,-0.2026090,-0.5475700, 0.3570100, 0.3774850,-0.3436380, 0.5815490,-0.8173570,-0.1970130,-0.9408670,-1.5778900,-1.3524290,-1.6628070,-1.4501020,-0.3234710, 0.1197060, 0.6644230, 0.1800530, 0.7196890,-0.7236000, 0.4688000, 0.1275000,-0.2202250,-0.4731390,-1.2633850,-0.7666130,-0.5260030,-0.0341330,-0.2658440,-0.8363430,-0.5876050,-1.0642850,-0.3611020, 0.2130360,-0.2708740, 0.3393470,-0.2544890,-0.1145520,-0.0533730,-0.1420230,-0.6668560,-0.4017130,-0.5825860,-0.8182030,-0.2270110,-0.2151930,-0.0376160,-0.2287000,-0.4861000,-0.4631000,-0.8906410, 0.7209530,-0.1938850,-0.0970310, 0.2014100,-0.2061280,-0.6552500,-0.5205240,-0.6497670,-0.0345130,-0.1526680,-1.1017460,-0.6125140, 0.6468520, 1.1245170, 1.7992040, 0.8007240, 0.4361400, 0.6658480, 0.9980370, 0.8568950,-0.5250560,-0.6065460,-0.1884800, 0.7987000,-0.3027000,-0.5805000,-0.3833000,-0.8856000, 0.4955710, 0.6798560,-0.6187010,-0.0446710,-0.1062380, 0.5514000, 0.4572410,-0.2865880, 0.9017460,-0.1856470, 0.9540480, 0.6843120, 0.4255160,-0.6808060,-0.1002980,-0.1300910, 0.6967340, 0.5139730, 0.9469860, 0.0247630, 0.7682220,-0.6193860, 0.7823020, 0.7709000, 0.1061000,-0.3468000, 0.5057000, 0.4204000,-0.7110000,-0.0313860,-0.2184310, 0.3214400, 0.2551310,-0.1460600, 0.8302230, 0.1292010,-0.5003770, 0.6386290,-0.4114260,-0.5698240,-0.1479490,-0.0276480, 0.0920200, 0.0202610, 0.1142250, 0.1945920, 0.3196130,-0.5447300,-0.6443990,-0.3923000,-0.6752000, 0.2396000,-0.4658000,
 0.4895000,-0.7518000, 0.2144000, 0.8165000,-0.4578000, 0.7424000,-0.6029000, 0.1207000,-0.0900000, 0.8701000,-0.4419000, 0.4726000,-0.4408780,-0.1420870, 0.6038550,-0.7705710,-0.0867000, 0.6782000, 0.8185000,-0.1058000, 0.5892000,-0.6872000,-0.0856000, 0.2182000, 0.0556000,-0.1519000, 0.8129000, 0.2358000, 0.1517000, 0.1647000, 0.5813000,-0.2563000, 0.4418000,-0.1128000, 0.6663000,-0.2941640,-0.2939480, 0.2234030, 0.8786810, 0.8079100,-0.7377910, 0.0742830, 0.7893790,-0.0485300,-0.2923730, 0.3547720,-0.4183980,-0.5614150, 0.6002280,-0.6804320, 0.3538040,-0.1679420,-0.5938000,-0.5546000,-0.1551000, 0.2766000, 0.2338000, 0.8962000,-0.1391000, 0.5945730, 0.8307130, 0.0612570, 0.8697730, 0.6450170,-0.6106700, 0.7876460,-0.6619150, 0.6644400, 0.2037690, 0.2590250, 0.4802910, 0.2715820, 0.5215350,-0.5960480,-0.3745820,-0.4906770,-0.6474990, 0.6278560,-0.4726160, 0.6063640,-0.6208810, 0.4773590, 0.5306000,-0.0726000, 0.7223000,-0.1481000,-0.5544600, 0.0987200,-0.8868150,-0.4918590, 0.4208660,-0.2053830,-0.4104660,-0.4314470, 1.1209780, 0.6935610, 1.5632700, 1.1031090, 0.5715620,-0.5713020,-0.2483420,-0.1680880,-0.1321490,-0.3571390,-0.3684860,-0.4666640,-0.9132720,-1.1021320, 0.4332420,-0.6853160,-0.0322300, 0.3010000, 0.2826000, 0.0594000, 0.3486450,-0.5329100, 0.3979120,-0.0104180, 0.9671110, 1.0313740, 1.1945010, 0.6614130, 1.0255260, 0.7461690, 0.7901930,-0.0746740, 0.3452840, 0.5221510,-0.6628860, 0.0430270, 0.7651710, 0.4054740, 0.5749520, 0.0368300,-0.8909310,-0.2055820,-0.9122080,-0.1043570,-0.7785140,-0.8336000, 0.7185000,-0.8630000, 0.3836210, 0.7179540, 0.3874500,-0.7406160, 0.6028830, 0.5640530, 0.2301910, 0.5111440, 0.5437800, 0.1701770, 0.0478720, 0.1170490,-0.1649640, 0.2738940, 0.2690840,-0.5189110,-0.0180040, 0.6336700,-0.8940500, 0.5301310,-0.4452650,-0.9658210,-0.2947970,-0.3546890,-0.9020060, 0.3534090,-0.4188000, 0.8293040,-0.8066620,-0.3400770, 0.0242770, 1.0598010, 1.1051450, 0.3975290,-0.3163370, 0.8184070, 0.3554130, 0.6981470, 0.6698610, 0.2774340,-0.1181820,-0.5264590,-0.4450050, 0.1446700, 1.1610210,-1.3184560, 0.2903020,-0.3238070,-0.5571260,-0.2668570,-0.2269720,-1.2484220, 0.4607400,-0.7315140, 0.6589980, 0.2909360,-0.0123570,-0.1193010,-0.7068180, 1.2203010, 0.3224950, 0.2044070, 0.5565310,-0.3687110,-0.2608360,-0.0684590,-0.1513440, 1.3280780, 0.6346840,-0.2436780, 0.2283570,-0.5226640,-0.2716510, 0.0837970, 0.1552650, 0.4426390,-0.7350220,-1.0716880,-1.7525720, 0.1834790,-0.2725260,-0.6226890, 0.7370960,-0.4790970,-0.2325090,-0.0120000,-0.2950360, 1.1592480, 1.0591310, 0.1898720, 0.6547390, 0.1038770, 0.3596880, 0.3450840, 0.6022150,-0.4919460, 0.3594170, 0.7187950, 0.6592030, 0.0768230,-0.2077980,-0.5935570,-0.5421890,-1.7783450,-0.5564870,-2.1611040,-1.9254220,-0.6814650,-0.0457860, 0.6930830, 0.0998510, 0.4698230, 0.7038580,-0.6457920, 0.5120520, 0.0484630, 0.9469290, 0.8525880,-0.0309520,-0.9434990,-0.6133770, 0.0040210, 0.1898200,-1.4446530, 0.1021040, 1.7866090, 0.5951070, 0.3461920, 0.6108920, 0.3287050, 0.1588350,-0.3308270, 0.2340450,-1.0369840,-2.0609510,-1.6739630,-0.2761860, 0.1570900,-0.7643870,-0.5511730, 0.1316630, 0.4030790,-0.3625000, 1.3758940,-0.0117930, 0.3843740, 0.5696620,-0.1990790,-0.8690930,-0.8856220,-1.1359590,-0.6147790,-0.7667080, 0.0166580, 1.3635990, 1.1219830, 0.7982620, 0.3254050, 1.6689070, 0.9914980, 0.1915710, 0.0676810,-0.7499710,-0.2837970,-0.2762390, 0.7601730,-0.5878080,-0.5694670,-0.2988870, 0.0791440, 0.7901100,-0.4294260,-0.7754820, 0.2023370, 0.0775940, 0.3299020, 0.3318890,-0.5675910,-0.0812540, 0.1491940,-0.4525740,-0.2313390, 0.1051760, 0.2937230, 1.1889010, 0.4156490, 0.8574840, 1.2965750,-0.1212320, 0.3038840,-0.1425760,-1.3700660,-0.2075930,-0.1709860,-0.7577680,-0.3301650, 0.6105770,-0.0575770,-0.0464050, 0.1806470,-0.8636210,-1.6599160,-0.3032760, 1.0194550, 0.2788570,-1.1752560,-0.0201380,-0.8923090,-0.4459250, 0.6344850,-0.2178030,-0.0603550,-0.3641660,-0.8360890, 0.3358790,-0.2710560, 0.7468010, 0.3114450, 0.6578080,-0.8619460,-0.0098530,-0.0451440,-0.6676710, 0.8022780,-0.0644740, 0.3590220, 0.0076520, 0.7282920, 0.3803780,-0.6698770, 0.1666360,-0.7426260, 0.3361760,-0.6016330,-0.0585590, 0.0149500, 0.5558590, 0.2830920, 0.3827490,-0.9956210, 0.4921880,-0.5013300,-0.4352850,-0.0526710, 0.5835330,-0.1698920, 0.0767270, 0.0388150, 0.5347420,-0.4733390,-0.1137010,-0.0070550,-0.0076120, 0.0296200,-0.5771280, 0.9762720,-0.2137070, 0.9458200,-0.7418550, 0.5993680,-0.1906230, 0.1968070,-0.7652140,-0.1290020, 0.2073080,-0.2972450,-0.7798090, 0.1784370, 0.9500340, 0.6858500, 0.2780560,-0.3528210, 0.0605920, 0.8447260, 0.1392700,-0.0661530,-0.7786700,-0.4473630,-0.8522410,-0.2588750,-0.4477790,-0.7834430,-0.4102300, 0.5935630, 0.9555780,-0.1131300, 0.0027800,-0.4397390, 0.3484290, 0.3857900,-0.9602200, 0.1054950, 0.6452450, 0.6068460,-0.0129440, 0.1007990,-0.4756980, 0.1211390,-0.3638480, 0.6572880,-0.7203160, 0.0191670, 0.5049630, 1.2135750,-0.0699260,-0.4850900,-0.8358010,-0.4941940,-0.3127830, 0.3615810, 0.9290150, 0.1717500,-0.1645760, 0.8762720,-0.1423680,-0.3246680,-0.0067630,-0.3853940,-0.2198290, 0.2362680, 0.9480280,-0.6087950,-0.8178320, 0.6382210, 0.6211630,-0.2945740, 0.1330890, 0.1979380,-0.9181760, 0.2562150, 0.5722030, 0.5467600, 0.9895040,-0.4804770,-0.4466000,-0.7109670, 0.1499190,-0.6574320,-0.5612630,-0.3742510,-0.6627800,-0.1434300,-0.6823340,-0.9530560, 0.3849380,-0.6172560,-0.4876740, 0.6513280,-0.4848440, 0.2219070, 0.5275370,-0.1972940,-0.3580760, 0.3125300,-0.8455970,-0.2156360, 0.4190070, 0.0106380, 1.5203770, 0.9751340, 0.0997170, 0.2835920,-0.8876990,-0.0864790,-0.4734840,-0.4182440, 0.6101040, 0.1875670,-0.2715700,-0.4549050,-0.1327300,-0.5738170,-0.3993790,-1.5233890, 0.5620360, 1.2122580,-0.1147240, 0.2725960,-0.4580240, 0.1634150, 0.5491220,-0.5149020,-0.1566320,-0.0109130,-0.0829040,-0.0999200, 0.3047150, 1.3021530, 0.2918960, 0.4222830,-0.4122000, 0.5213360,-0.4997770,-0.0773440, 0.0986430,-0.0635530, 0.1946480, 0.2459880,-1.0656090, 0.7345850,-1.3637200,-0.4083680, 1.4773960, 0.4263750, 0.2048030,-0.1445790, 0.1561560,-0.0600880, 0.2596990, 1.0169940,-0.6582190, 0.5362340,-0.7510860, 1.0091130, 0.6734670,-0.0294040, 0.3919390,-0.5131490, 0.1098000, 0.6576050,-0.3686540, 0.6175230, 1.3956940, 0.2629340,-0.2419930,-0.0840060,-0.1862460, 0.2065420,-0.8356360, 0.2607540, 0.8077940,-0.2850810, 0.1935730, 0.6341900, 0.3354890,-0.1188070, 0.0350340,-0.1156800, 0.3838460,-0.5551310, 0.1833460, 0.2227830, 0.8475520, 0.6909520, 0.3245570,-0.3133810,-0.3390000,-0.4176650,-0.4793540,-0.0713320, 0.6950110,-0.2828850,-0.1112440,-0.0002670, 0.2513060,-1.0923940, 0.0335600,-0.0305660,-0.6874830, 0.3648340, 0.3397450,-0.3956080, 1.0344590,-0.1959030, 0.1181340, 0.4913340,-0.1064510,-0.1025680,-0.2237260, 0.9815720, 0.8751570, 0.2505580, 0.5284250, 0.0321600,-0.2926000,-0.2619000, 0.0428440, 1.3042730,-0.4909680, 0.5990930, 0.4354910, 0.8959870,-0.2274670,-0.1005020, 0.4882490, 0.0662730,-0.3802500,-1.1538240, 0.5433280,-0.1199180,-0.4502520, 0.4963720,-0.8287790, 0.2553680, 0.3603480, 0.3867200,-0.3314100, 0.3895440, 0.2554230,-0.3894650,-0.6607790,-0.4439840,-0.5808000, 0.3048000, 0.1169530,-0.2702990, 0.3697040, 0.1009800, 0.2064420,-0.1584300,-0.6185630,-0.1939450,-0.2573260, 0.0280080, 0.1166970,-0.1555760,-0.0619040, 0.1093600, 0.6727740,-0.4668890, 0.1512050, 0.9340290, 0.2312250, 0.4863970,-0.0019200,-0.5968090,-0.6668420,-0.0069130, 0.1061870, 0.7087000,-0.4370000, 0.8161000,-0.2340040,-0.8485410, 1.0284980, 0.5959610, 0.6007280, 0.8610630,-0.5039490,-0.1163230, 0.3093610,-0.0084860,-0.7447810, 0.3905240,-0.7472530,-0.2568570, 0.2664800, 0.1772440,-0.7786980, 0.5254040, 0.9272240,-0.1767760, 0.6918100,-0.7735730, 0.1233760,-0.1233230,-0.6713490, 0.5091000, 0.1479000,-0.0259000,-0.4172040,-0.4939080,-0.2763010,-0.5838500, 0.5862780,-0.0044470, 0.6530500, 0.4253360, 1.0405780, 0.3399880, 0.1339490, 1.2481060, 1.0905860,-0.8933160, 0.5160470, 0.4197380,-0.4969250,-0.1844290,-0.3482330, 0.5659340,-0.6832230,-0.4794400,-0.5987420, 0.8091670,-0.7687140,-0.6692000,-0.5168000,-0.2996000, 0.0523000, 0.0200200, 0.2495970, 0.1084040,-0.4452110, 0.7996380,-0.1728640, 0.2713590, 0.8987350, 0.3206050, 0.7815500,-0.3865020,-0.3416330,-0.7618080, 0.6316420, 0.6944960, 0.0631410,-0.6900200, 0.1099860, 0.1447960,-0.2659860, 0.2831350, 0.8831940, 0.2170000,-0.1916000, 0.4286000,-0.3590000,-0.8591000,-0.7903000,-0.5044000,-0.8289260, 0.5182930, 0.0352390, 0.0550050,-0.7448790,-0.2794050, 0.4605870,-0.0773650, 0.0039050, 0.3050410, 0.4914630,-0.7964430,-0.8954720, 0.7735320, 0.3065020,-0.6778890,-0.0182240, 0.7797590,-0.3494040,-0.3410590,-0.1809000, 0.7439000, 0.1392000, 0.2264000,
 0.8586000, 0.6771000, 0.0382000,-0.8741000,-0.5205000, 0.0185000, 0.1871000,-0.2172000, 0.1307000, 0.1920000,-0.2578000,-0.8842000, 0.4397000, 0.5356150,-0.6407760, 0.1548000,-0.7183000,-0.8017000, 0.2083000, 0.6792000, 0.6043000,-0.3406000, 0.2715000,-0.7933000, 0.8226000,-0.4092000,-0.4542000,-0.2363000, 0.3836000, 0.4506000, 0.5765000,-0.6732000,-0.5214000, 0.7167000, 0.1420050,-0.4811040, 0.5902820, 0.4242860,-0.4876210, 0.8661430,-0.7938690,-0.2359290,-0.0496290,-0.1879470, 0.1395970, 0.3494120,-0.1644010, 0.3469910, 0.5175710, 0.4045820,-0.5184190,-0.2789460,-0.3645000, 0.3600000, 0.5221000, 0.2992000,-0.4945000,-0.0685000,-0.7968000, 0.7887680,-0.4275910,-0.4767400, 0.2988510, 0.5791950, 0.5275470,-0.3284390, 0.5741040, 0.6005970,-0.4700900, 0.7619520, 0.4947410,-0.2831050, 0.4663910, 0.2304470, 0.5693160,-0.0619310, 0.6030220,-0.4446170,-0.0229660,-0.3363920, 0.7208040, 0.0983780, 0.1455000, 0.8811000, 0.0732000,-0.0443000, 0.5912000, 0.0169830,-0.7818610, 0.7468360,-0.7909800,-0.1741250, 0.8135330, 0.0315340, 0.4908200, 0.8181220, 0.9895400, 0.9874040, 0.1145380,-0.4359740, 1.0579440, 0.2795420,-0.4123500, 0.4947710, 0.7426840,-0.0288950,-0.2931940, 0.2979450, 0.6872700,-0.3087600, 0.5962190, 0.8455000, 0.8572000, 0.4590740,-0.8248380, 0.3638860, 0.1437990, 0.1789940,-0.4010010, 0.0734940, 0.6281270, 0.6793820, 0.3775320,-0.1054040, 0.8365400,-0.5101230,-0.1174000,-1.0592080, 0.3673620, 0.7032470,-0.5970940,-0.7127230,-0.5832950,-1.2512930,-0.5199920,-0.3724600,-1.0993300, 0.3134560,-0.9144080, 0.3368330, 0.7866000,-0.6177000, 0.2124080, 0.5030890,-0.8455590,-0.8337850,-0.3332490, 0.4197880,-0.3589560,-0.8832940,-0.5729210, 0.0290970,-0.3752050,-0.5037130, 0.8281240,-0.0489290, 0.2213020,-0.0391920,-0.3194540, 0.4568280, 0.0556560,-0.8485010,-0.5058550, 0.6009930,-0.1238210, 0.0482160,-0.3515080, 0.6019430,-0.3439000, 0.3174060, 0.3725560, 0.9312200, 0.1005900,-0.1067320,-0.8707470,-0.9403160,-0.0365140,-0.9379900,-0.8507440, 0.1874840,-0.4945650,-0.2307500,-0.5851300,-0.4416400, 0.2801790,-0.9649100,-0.5037370,-0.8545680,-0.8394900, 1.0244090,-0.8950240, 0.1018640,-0.1054280,-0.6324670, 0.0675100, 0.7349870,-0.2089000, 0.3484350,-0.4402080,-0.2521000,-0.1168790,-0.5547020,-0.5362480,-0.3838600,-0.6106870,-0.6972030,-0.3503130, 0.2000850,-0.4879420,-0.1687280, 0.0732160,-0.0358810,-0.9544060, 0.0953870, 0.4069560,-0.3767390,-0.1595750, 0.0831540,-0.3523700,-0.1491590,-0.9043730, 0.6381140, 0.4993120,-0.1109600,-0.7132180, 0.3370880,-0.7107240,-0.8681320,-1.5236670,-0.9615830,-0.0267730, 0.7562610,-0.7510960, 0.0798930, 0.1930950,-0.5509050,-0.5362430,-0.2797280,-0.1603570, 0.6023940,-0.2278100,-0.2561020,-0.5044080,-1.0990950, 0.3044790,-0.9357780, 0.1222240,-0.4903420,-0.6750570,-0.3729840,-0.5833310,-0.0164730, 0.0866640,-0.2820220, 0.0816480, 0.2979390, 0.5001560,-1.0635830,-0.3607520, 0.7522690,-0.9564760,-1.7873070,-0.3854520, 0.2300870, 0.2171310,-0.4004780,-0.1117070,-0.1177230,-0.4019530,-0.5449180,-0.1326400,-0.1728430,-0.7800900,-0.8245950,-0.9686630,-0.5152000,-1.2047870,-0.8472170,-0.5564240,-0.2164890, 0.3964320, 0.1589830,-0.3408040,-0.8300600,-0.2899060,-0.2999840,-0.3168750, 0.6691360,-1.2887960, 0.3785880, 0.4873450,-0.5659300,-0.3661070, 0.8406100, 0.9014040, 0.6065400,-0.2268790, 0.1838720,-0.5730940,-0.2769280, 0.2488860,-0.1855630,-0.0921460,-0.4317590, 0.1619780, 0.8520520,-0.7548160,-0.8785060, 0.6923720, 0.5919130,-0.5787330, 0.4955630, 0.4549440,-1.1202240,-0.3003500,-0.5114370, 0.9132030,-0.0532940,-0.4956600, 0.6350410,-0.3463830, 0.0595620, 0.6974280,-0.1579790, 0.1644760, 0.1275790,-1.1652950, 0.2424720,-1.0454380,-0.4707140,-0.6511880,-1.5693700,-1.4219830,-0.6469890, 0.2291160, 0.8065240, 0.7767970, 0.1822010,-0.4739270,-0.1641780,-0.7507730,-1.2489200,-1.4118510,-0.7308500, 0.2663600,-0.7443360,-0.3898650,-0.1419780, 1.5056650,-0.4642050,-0.5014790,-1.1203700, 0.3341610,-1.6159280, 0.6000720,-0.2282100,-0.1238880,-0.1362900,-0.4290700,-1.5995760,-0.6017880,-0.4979690,-1.1096460, 0.1683600,-0.1847800, 0.2280150,-0.2497960,-0.2908360,-0.9975660,-0.1764870,-1.3395060,-0.1104940,-0.9822070, 0.3132000, 0.6256180, 0.0647670,-0.2250610,-0.4012020,-1.0414200,-0.3469350,-0.3870300,-0.2066900,-0.0836940, 0.1876730,-0.4213240,-0.2941900, 0.6745000,-0.1006720, 0.7369710, 0.4373850,-0.6374820, 0.5617710,-0.0357530, 0.6901350, 0.2118500, 0.6395380,-0.9701490,-0.0095470,-0.2695340, 0.1592820,-1.0480950, 0.6878960,-0.3057640, 0.6587660, 0.3445170,-0.0169380,-0.1502580,-0.1608760,-0.4126000,-0.3279060, 0.4478840,-0.3895880,-0.1898550,-0.7910040, 0.4860170, 1.2217960, 0.9316950,-0.7593040, 0.2233950, 0.2213610, 0.8712190,-0.7009730, 0.2588080, 0.3059320,-0.2144780,-0.8309070,-0.0330590, 0.2720800,-0.1916480, 0.7117110,-0.1870230, 0.4008590,-0.3914270,-0.2435070,-0.0698120, 0.0077620, 1.1057130,-1.2839680,-0.2737540, 0.6325500,-0.8457980,-0.6590140, 0.3451000, 0.7158000,-0.0275910,-0.6367800,-0.9083220,-0.4444040, 0.3872660, 0.4156680,-0.5965100,-0.3955170,-0.4828740,-0.3970450, 0.5153850,-0.6920020,-0.7636200, 1.0067870,-0.5363390, 1.0032960, 0.1060720, 0.4461200,-0.0706970,-0.6260030,-0.3628670, 0.2043450, 0.8271590,-0.6074090,-0.1380660, 1.0578320,-0.2655650, 1.0500680, 1.4518070, 0.7553090,-0.7948050, 0.3930420, 0.7238000, 0.8440880, 0.0442490, 0.6092520, 0.9024900, 1.0066050, 1.1415010,-0.2453780, 0.9154930,-0.2306800,-0.1755620, 0.1790750,-0.4328780, 0.4160130, 1.4143380, 0.8342050, 0.5899690, 0.0419500, 0.4579280, 0.6711300,-0.1110540, 0.2873150, 0.4626300, 0.6708680, 0.9272890, 1.1671080, 0.1417840, 0.7081460,-0.5003910,-0.8218930,-0.1786460,-0.2337610, 0.3437360, 1.0119470, 0.2982180, 0.5551560, 1.3231400,-0.2626920, 0.8782060, 0.0878530, 0.7594230,-0.3266750,-0.4201190,-0.4937930, 0.4082920, 0.3147740, 0.2246740,-0.1773620, 0.8979280, 0.5185500, 0.8876330, 1.6000700, 1.1655700, 0.2014990, 0.7273140,-0.2555470,-0.7328690, 0.2732410,-0.4443870, 0.5819240, 2.1660690, 1.0660660, 0.6286660,-0.6957740, 1.2275250, 0.9471920,-0.5816560, 0.1642130, 0.7733960, 0.8496980, 1.6896450, 0.9781160, 0.4840490,-0.4551940, 0.6290900, 0.4007460,-0.1814520, 1.0836590, 1.0906800, 1.2700270, 0.0761560,-0.1805540,-0.5297870,-0.7855720, 0.5013000, 0.2151840,-0.5432210, 1.0369710,-0.1169690,-0.6061000, 0.2189920, 0.9315660, 0.1271960, 0.1246850, 1.0669220, 1.0974440, 0.7742050, 0.8128270, 0.6857260, 1.1797580, 1.4176100, 0.9264520, 0.7083550, 1.1321180, 0.1970760, 0.6419600, 0.9166890, 1.6667560, 0.2105670,-0.1233820,-0.5539560,-0.3272970,-0.7081040,-0.2952710, 0.2037350, 0.2918270, 0.1735890, 0.6846510,-0.3881390,-0.1647600,-0.5558170,-0.3163370, 0.3779410,-0.4874560, 0.5823020, 0.6575070,-0.3203220,-0.1374360, 0.1255830,-1.4142210, 1.2175580, 0.6817180, 0.2113400, 0.7993130, 0.0345180, 0.4908190, 0.4259050, 0.4449500, 0.3593410, 0.7209230, 0.5114560,-0.1917870, 0.4266200, 0.3110420, 0.2994030, 0.2082250,-0.2189880, 0.1791580,-1.5978410, 0.5071950,-0.6098100,-1.1355430,-0.5795770,-1.0139920,-0.0583240,-0.8610110,-0.1910870, 1.2420440,-0.9256410, 0.2731410,-0.0952210, 0.4422660,-0.0558470,-0.3725150, 0.5712200, 0.7629450, 0.0040070,-0.6172520,-0.3852000,-0.3423000, 0.8585480,-0.5990140,-0.4871340,-0.0550480,-0.0534140, 0.2432450, 0.7307050,-0.0201240, 0.3095730,-0.2161260,-0.0556270,-0.9222740,-0.5686190,-0.3470720,-1.1396020,-1.2591270,-0.3620520,-0.2081620,-0.3777670,-0.2053110, 0.2391080,-0.9208520, 0.2398430,-0.4664240,-0.5230740,-0.6355000,-0.3881000, 0.0844000, 0.8204060,-0.6607770, 0.2734200, 0.2558370,-0.9272130,-0.9595830,-1.1147960,-0.1385350,-0.3169760, 0.2640380,-0.1099220,-0.6177710,-0.0403390,-0.4108210, 0.5944920, 0.4592710,-0.8048720,-0.5438120,-1.1228290,-0.2767080,-1.5562470,-0.4861430, 0.6504680, 1.0910890,-0.1847540, 0.3871000,-0.0378000, 0.4960000,-0.0328010,-0.7270430,-0.1022250,-0.0584960,-0.1351490,-0.2762090,-1.8792510,-1.4316300,-1.4358400,-2.5010570,-1.8770820,-2.5742390,-1.6836890,-2.0075260,-1.9194700,-2.4416160,-0.5985490,-0.4984650,-1.2894850,-0.2745680,-0.2918980, 0.0804010, 0.3036000, 0.5195110, 0.4558240, 0.0734000,-0.2296000,-0.4041000,-0.6586000, 0.1981510,-0.3463570, 0.6327040,-0.6487690,-0.3137180,-0.8520690,-0.1464300,-0.9495970,-0.3777310,-1.7677340,-1.2960040,-0.8597520,-0.2359030,-0.7407360, 0.8416350, 0.1983510,-0.9912800, 0.0812890,-1.1119810, 0.0244140, 0.7551050, 0.8247510,-0.0227030,-0.6534000, 0.3830000,-0.7355000, 0.2294000,-0.2626000, 0.4259000, 0.8483840,-0.3930500, 0.1135470,-0.5501090, 0.5077940,-0.7178550,-0.8781830, 0.3462040,-0.5927810, 0.0866240, 0.2842700,-0.6238550, 0.3182420,-0.8388430, 0.1341220,-0.0055800,-0.6091300,-0.7991490, 0.3673180, 0.4914340, 0.7461000, 0.2364000, 0.6804000,-0.2834000,

 1.6607560, 0.3172630,-1.6163330, 6.3892740, 0.7968500,-0.0623880,-0.2220940,
 1.8403950, 0.4346420,-2.7185990, 8.4255860, 0.8026380,-0.5122110,-0.7568110,
 2.9952470, 0.7933410, 2.3511700,-0.2726000,-1.4991860,-0.3859660,-3.2672000,
-0.7207520,-0.8591020, 1.6693450, 1.7486960, 1.1425950, 1.6178900,-0.0774000,
 6.4178520, 0.0583360, 3.1722030,-1.0006130,-2.7730540, 0.1041180, 5.2981770,
 1.0184650,-2.3350870,-2.2548340,-1.6518840, 1.6927980,-0.0879640, 1.4802400,
 1.4859870,-4.4175790,-1.3996840,-2.9189890,-1.7992430, 3.7585340,-2.3671950,
 2.3549730, 4.2584400, 2.2620930, 3.4490580,-0.0425240,-4.6678380,-3.8839620,
 1.9594780, 2.8785290, 2.8678540,-0.1955130, 0.2964510,-4.0302990,-0.4547760,

 2.2179170, 4.3427660,-1.0707080,-4.3444080,-2.7079850,-1.4452590,-2.9488280, 3.1879660,-2.2935330
}; // 22240 bytes = 72% of Arduino-UNO's programmable memory (?)

// Images of handwritten Numbers in byte form. 
const PROGMEM byte NumbersInPixels[2][784] = { 
{
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0, 67,128,188,254,254,255,254,254,181,123, 38,  3,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0, 94,249,251,202,136, 88, 89,136,136,160,230,253,186, 21,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0, 22,235,193, 60,  0,  0,  0,  0,  0,  0,  0, 15, 99,214,205,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0, 88,235, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 65,253, 49,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0, 25,121,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,236, 79,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,107,253, 43,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,118,247,174,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 49,211,249,144,  8,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  2, 20, 62, 98,152,175,242,254,211, 85,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0, 20,253,253,253,254,253,253,253,207, 57,  6,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  9,117,117,117, 63, 51,117,140,236,253,220, 95,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14, 92,241,253,229, 60,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,121,248,230, 51,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 53,244,203,  3, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,153,253, 19, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,141,253, 19, 0,0,0,0,
0,0,0,0, 0,13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   5, 44,134,254,189,  0, 0,0,0,0,
0,0,0,0,16,231,112, 40, 25,  0,  0,  0,  0,  0,  0, 25, 40,100,197,253,208,125, 27,  0, 0,0,0,0,
0,0,0,0, 3,168,253,253,239,215,172,136,191,215,215,238,254,253,253,150,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  3, 62,122,175,187,229,253,254,193,175,175, 98, 97, 31,  2,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0, 
},
{
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0, 38,113,113,113,114,238,253,253,253,255,206, 88,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0, 57, 85,147,234,252,252,252,253,252,252,252,252,253,252,246, 75,  0, 0,0,0,0,
0,0,0,0, 0, 67,197,234,252,253,252,252,252,252,196,195,195,195,195,253,252,252, 84,  0, 0,0,0,0,
0,0,0,0, 0, 85,252,252,252,225,223,114, 84, 84,  0,  0,  0,  0, 16,253,252,214, 28,  0, 0,0,0,0,
0,0,0,0, 0, 38,221,157,112,  0,  0,  0,  0,  0,  0,  0,  0, 16,203,253,252,118,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 26,207,253,255,168,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,104,252,252,215, 33,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 67,240,252,220, 31,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 29,181,252,217, 37,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,253,252,252, 84,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0, 76,191,255,215,110,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0,  0, 19,196,252,253,121,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,  0, 67,209,252,252, 56,  6,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0, 29,181,252,217, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,  0,  0,253,252,252, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0, 13,191,255,215, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0,  0,154,252,253,121,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0, 13,187,252,133,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0, 57,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,
0,0,0,0, 0,  0, 57,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,  
}};// there was no more memory for another Number(s)InPixels for Arduino-UNO (unless you flash it without a bootloader) 

unsigned int timestamp;

void setup()
{
  Serial.begin(9600);
  while (!Serial){ }; 

  // Creating a NeuralNetwork with pretrained Weights and Biases
  NeuralNetwork NN(layers, weights, biases, NumberOf(layers));

  //Goes through each image
  for (unsigned int i = 0; i < 2; i++)           
  {
    timestamp = millis();  
    // FeedForwards each Individual Pixel by first normalizing it bettween 1 and 0     
    for (unsigned int j = 0; j < 784; j++) // and then it returns the predicted output(s).
      output = NN.FeedForward_Individual(pgm_read_byte(&NumbersInPixels[i][j])/255.0); 

    Serial.println((String)"Predicted [" + (round(output[0]* 9)) + "] - Under " + (millis() - timestamp) + " milliseconds."); // (outputs[0]* 9.0) = denormalizing/converting prediction back to decimical (i think i should have used 10 instead of 9 when i was training but nvm...)
  }
}
void loop(){}
